/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.plant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.assets.entities.plant.model.PlantEntityAsset;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpecies;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpeciesDictionary;

public class PlantEntityAssetsBySpecies {
    private final PlantSpeciesDictionary speciesDictionary;
    private Map<PlantSpecies, List<PlantEntityAsset>> speciesMap = new HashMap<PlantSpecies, List<PlantEntityAsset>>();
    public static final PlantEntityAsset NULL_ENTITY_ASSET = new PlantEntityAsset();
    private static final PlantSpecies NULL_SPECIES;

    public PlantEntityAssetsBySpecies(PlantSpeciesDictionary speciesDictionary) {
        this.speciesDictionary = speciesDictionary;
        for (PlantSpecies plantSpecies : speciesDictionary.getAll()) {
            this.speciesMap.put(plantSpecies, new ArrayList());
        }
        this.speciesMap.put(NULL_SPECIES, new ArrayList());
    }

    public void add(PlantEntityAsset asset) {
        if (asset.getSpeciesName() != null) {
            PlantSpecies plantSpecies = this.speciesDictionary.getByName(asset.getSpeciesName());
            this.speciesMap.get(plantSpecies).add(asset);
        } else if (asset.getSpeciesNames() != null) {
            for (String speciesName : asset.getSpeciesNames()) {
                PlantSpecies plantSpecies = this.speciesDictionary.getByName(speciesName);
                this.speciesMap.get(plantSpecies).add(asset);
            }
        } else {
            for (List<PlantEntityAsset> entityAssetList : this.speciesMap.values()) {
                entityAssetList.add(asset);
            }
        }
    }

    public PlantEntityAsset get(PlantEntityAttributes attributes) {
        List<PlantEntityAsset> entityAssets;
        int numAssets;
        PlantSpecies plantSpecies = attributes.getSpecies();
        if (plantSpecies == null) {
            plantSpecies = NULL_SPECIES;
        }
        if ((numAssets = (entityAssets = this.speciesMap.get(plantSpecies)).size()) == 0) {
            return NULL_ENTITY_ASSET;
        }
        return entityAssets.get(Math.abs((int)attributes.getSeed()) % numAssets);
    }

    public List<PlantEntityAsset> getAll(PlantEntityAttributes attributes) {
        PlantSpecies species = attributes.getSpecies();
        return this.speciesMap.get(species);
    }

    static {
        NULL_ENTITY_ASSET.setType(null);
        NULL_ENTITY_ASSET.setUniqueName("Null entity asset");
        NULL_ENTITY_ASSET.setSpeciesName("None");
        NULL_SPECIES = new PlantSpecies();
        NULL_SPECIES.setSpeciesId(-1L);
        NULL_SPECIES.setSpeciesName("Null species");
    }
}

